<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Content Tour
 */
$turista_t_period = get_post_meta(get_the_ID(), '_turista_t_period', true); 
$turista_single_page_title = get_post_meta(get_the_ID(), '_turista_single_page_title', true); 
$turista_tour_gallery_images = get_post_meta(get_the_ID(), '_turista_tour_gallery_images', true); 
$turista_google_map_title = get_post_meta(get_the_ID(), '_turista_google_map_title', true); 
$turista_google_map = get_post_meta(get_the_ID(), '_turista_google_map', true); 
$turista_cont_form_title = get_post_meta(get_the_ID(), '_turista_cont_form_title', true); 
$turista_cont_form_code = get_post_meta(get_the_ID(), '_turista_cont_form_code', true); 

?>

<!-- START BLOG -->
<section class="tour_details section-padding">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-md-7 col-xs-12">
				<div class="single_tour_details">
					<span class="tour_duration"><i class="icofont-clock-time"></i> <?php echo esc_html($turista_t_period);?></span>
					<h3 class="tour_title"><?php echo esc_html($turista_single_page_title);?></h3>
					<?php if($turista_tour_gallery_images){ ?>
						<div class="tour_slider">
						<?php
						foreach ( (array) $turista_tour_gallery_images as $attachment_id => $attachment_url ) { ?>					
							<div class="tour_slider_img"><?php echo wp_get_attachment_image( $attachment_id, 'full' );?></div>					
						<?php }	?>
						</div>
					<?php }	?>						
					<?php the_content();?>

					<!-- START MAP -->
					<div class="tour-map">
						<h3 class="tour_title"><?php echo esc_html($turista_google_map_title);?></h3>
						<?php echo turista_wp_kses($turista_google_map);?>
					</div>
					<!-- END MAP -->
				</div>							
			</div><!--- END COL -->
			
			<div class="col-lg-4 col-md-5 col-xs-12">
				<div class="book_now">
					<h4><?php echo esc_html($turista_cont_form_title);?></h4>
					<div id="contact-form">
						<?php 
							if($turista_cont_form_code){
								echo do_shortcode($turista_cont_form_code);
							}								
						?>
					</div>	
				</div>				
			</div><!--- END COL -->
		</div><!--- END ROW -->
	</div><!--- END CONTAINER -->
</section>
<!-- END BLOG -->