<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Turista
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="single_blog blog-details">
		<div class="blog-text">	
			<h4><?php the_title();?></h4>		
			<div class="post-meta">	
				<span>
					<i class="icofont-clock-time"></i> <?php echo get_the_time('d M Y');?>
				</span>	
			</div>
			<div class="post_description">	
				<?php the_content();?>
			</div>	
			
			<?php
			
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'turista' ),
					'after'  => '</div>',
				) );
			?>
		</div>							
	</div>	
</article><!-- #post-<?php the_ID(); ?> -->
