<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Turista
 */
$turista_embede_code = get_post_meta(get_the_ID(), '_turista_embed_code', true); 

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="single_blog">
	<?php if($turista_embede_code){ ?>
		<div class="blog_embed_code">
			<?php echo turista_wp_kses($turista_embede_code);?>
		</div>
	<?php } ?>

		<div class="blog-text">	
			<h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>		
			<div class="post-meta">	
				<span>
					<i class="icofont-clock-time"></i> <?php echo get_the_time('d M Y');?>
				</span>	

				<span>
					<i class="icofont-comment"></i> <?php comments_popup_link( '0 Comments', '1 Comment ', '% Comments ', 'comments-link', ' 0 Comments '); ?>
				</span>
			</div>
			<div class="post_description">	
				<?php the_excerpt();?>
			</div>	
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'turista' ),
					'after'  => '</div>',
				) );
			?>
		</div>							
	</div>	
</article><!-- #post-<?php the_ID(); ?> -->