<?php 
/**
 * The template for displaying all single Tour
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Turista
 */
 
get_header();
turista_single_page_banner();
$related_tour_subtitle = get_post_meta(get_the_ID(), '_turista_related_tour_subtitle', true); 
$related_tour_title = get_post_meta(get_the_ID(), '_turista_related_tour_title', true); 

?>	

	<?php
	while ( have_posts() ) :
		the_post();

		get_template_part( 'template-parts/content', 'tour' );

	endwhile; // End of the loop.
	?>

	<!-- START DEALS & DISCOUNT -->
	<section class="related-deal section-padding">
		<div class="container">		
			<div class="row">
				<div class="col-md-12" data-aos="fade-up">
					<div class="section-title text-center white-title">
						<?php if($related_tour_subtitle){ ?>
							<span><?php echo esc_html($related_tour_subtitle);?></span>
						<?php } if($related_tour_title){ ?>
							<h2><?php echo turista_wp_kses($related_tour_title);?></h2>	
						<?php } ?>		
					</div>
				</div><!-- END COL -->
			</div><!-- END ROW -->	
			
			<div class="row text-left">
				<div class="col-md-12" data-aos="fade-up">
					<div id="package-slider">

						<?php // WP_Query arguments
							$args = array (
								'post_type'              => array( 'tour' ),
								'post__not_in' => array($post->ID),
								'posts_per_page'=> -1
							);

							// The Query
							$related_tour_query = new WP_Query( $args );

							// The Loop
							if ( $related_tour_query->have_posts() ) {
								while ( $related_tour_query->have_posts() ) {
									$related_tour_query->the_post(); 
									$turista_t_price = get_post_meta(get_the_ID(), '_turista_t_price', true);
									$turista_t_period = get_post_meta(get_the_ID(), '_turista_t_period', true);
									$turista_tour_button_text = get_post_meta(get_the_ID(), '_turista_tour_button_text', true);
									$turista_tour_rating = get_post_meta(get_the_ID(), '_turista_tour_rating', true);
												
									?>
									
									<div class="single_package"> 
										<div class="pack_image">
											<?php the_post_thumbnail('turista_image_1200_800');?>		
										</div>
										
										<div class="package-hover">
											<div class="pull-left"><h5><?php the_title();?></h5></div>
											<div class="pull-right"><span class="pack_price"><?php echo esc_html($turista_t_price);?></span></div>
											<div class="clearfix"></div>
											<div class="rating">
												<?php if($turista_tour_rating == '2'){
													echo '
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
													';
												}elseif($turista_tour_rating == '3'){
													echo '
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
													';
												}elseif($turista_tour_rating == '4'){
													echo '
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
													';
												}elseif($turista_tour_rating == '5'){
													echo '
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
														<i class="fa fa-star"></i>
													';
												}else{
													echo '
														<i class="fa fa-star"></i>
													';
												}?>

											</div>									
											<span class="time_zone"><i class="icofont-wall-clock"></i> <?php echo esc_html($turista_t_period);?></span>
											<p><?php turista_readmore_content(14);?></p>									
											<a href="<?php the_permalink();?>" class="btn-bg"><?php echo esc_html($turista_tour_button_text);?></a>
										</div>
									</div><!-- END SINGLE PACKAGE -->
					
							<?php	}
							} else {
								// no posts found
							}

							// Restore original Post Data
							wp_reset_postdata();?>	
							
					</div>
				</div><!-- END COL -->
			</div><!-- END ROW -->
		</div><!-- END CONTAINER -->
	</section>
	<!-- END DEALS & DISCOUNT -->

<?php get_footer();?>	