<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Turista
 */

get_header();
turista_search_banner()
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main">
		<!-- blog-section - start -->
		<section id="blog-section" class="blog-section clearfix">
			<div class="container">
				<div class="row justify-content-center">

					<div class="col-lg-8 col-md-10 col-sm-12">
					
					<?php if ( have_posts() ) : ?>

						<?php
						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

							/**
							 * Run the loop for the search to output the results.
							 * If you want to overload this in a child theme then include a file
							 * called content-search.php and that will be used instead.
							 */
							get_template_part( 'template-parts/content', 'search' );

						endwhile;
						?>
						
						<div class="pagination-nav ul-li-center clearfix">
							<span class="pagination clearfix">
								<!-- pagination -->
								<?php the_posts_pagination( array(
									'mid_size' => 2,
									'prev_text' => turista_wp_kses( '<i class="icofont-long-arrow-left"></i>' ),
									'next_text' => turista_wp_kses( '<i class="icofont-long-arrow-right"></i>' ),
								) ); ?>
					
							</span>								
						</div>	
							
						<?php
						else :

							get_template_part( 'template-parts/content', 'none' );

						endif;
						?>

					</div>

					<div class="col-lg-4 col-md-6 col-sm-12">
						<aside id="sidebar-section" class="sidebar-section clearfix">
							<?php get_sidebar();?>
						</aside>
					</div>

				</div>
			</div>
		</section>
		<!-- blog-section -->
	</main><!-- #main -->
</div><!-- #primary -->	

<?php

get_footer();
