<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Turista
 */

get_header();
turista_blog_banner();
?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">
		<!-- blog-section - start -->
		<section id="blog-section" class="blog-section clearfix">
			<div class="container">
				<div class="row justify-content-center">

					<div class="col-lg-8 col-md-10 col-sm-12">
					
						<?php
						if ( have_posts() ) :

							/* Start the Loop */
							while ( have_posts() ) :
								the_post();

								/*
								 * Include the Post-Type-specific template for the content.
								 * If you want to override this in a child theme, then include a file
								 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
								 */
								get_template_part( 'template-parts/content', get_post_format() );

							endwhile;

							?>
							<div class="pagination-nav ul-li-center clearfix">
								<span class="pagination clearfix">
									<!-- pagination -->
									<?php the_posts_pagination( array(
										'mid_size' => 2,
										'prev_text' => turista_wp_kses( '<i class="icofont-long-arrow-left"></i>' ),
										'next_text' => turista_wp_kses( '<i class="icofont-long-arrow-right"></i>' ),
									) ); ?>
						
								</span>								
							</div>							
							<?php

						else :

							get_template_part( 'template-parts/content', 'none' );

						endif;
						?>					
	
					</div>

					<div class="col-lg-4 col-md-6 col-sm-12">
						<aside id="sidebar-section" class="sidebar-section clearfix">
							<?php get_sidebar();?>
						</aside>
					</div>

				</div>
			</div>
		</section>
		<!-- blog-section -->
	</main><!-- #main -->
</div><!-- #primary -->		
<?php

get_footer();
