<?php

function turista_header()
{
	global $turista;

	$turista_preloader_opt					 = '';
	$turista_homepage_opt					 = '';
	$turista_header_dis_opt						 = '';


	if (isset($turista['turista_preloader_opt'])) {
		$turista_preloader_opt = $turista['turista_preloader_opt'];
	}

	if (isset($turista['turista_homepage_opt'])) {
		$turista_homepage_opt = $turista['turista_homepage_opt'];
	}

	if (isset($turista['turista_header_dis_opt'])) {
		$turista_header_dis_opt = $turista['turista_header_dis_opt'];
	}

	$turista_custom_logo_id = get_theme_mod('custom_logo');
	$turista_custom_logo = wp_get_attachment_image_src($turista_custom_logo_id, 'full');
?>

	<?php if ($turista_header_dis_opt == '2') { ?>

		<?php } else {

		if ($turista_preloader_opt == '1' && !$turista_homepage_opt == '1') { ?>

			<!-- START PRELOADER  -->
			<div class="preloader">
				<div class="status">
					<div class="lds-dual-ring"></div>
				</div>
			</div>
			<!-- END PRELOADER -->

		<?php } elseif ($turista_preloader_opt == '1' && $turista_homepage_opt == '1') { ?>

			<?php if (is_front_page()) { ?>

				<!-- START PRELOADER  -->
				<div class="preloader">
					<div class="status">
						<div class="lds-dual-ring"></div>
					</div>
				</div>
				<!-- END PRELOADER -->

		<?php }
		} ?>

		<!-- START NAVBAR -->
		<div id="navigation" class="fixed-top navbar-light bg-faded site-navigation">
			<div class="container">
				<div class="row">
					<div class="col-lg-2 col-md-3 col-sm-4">
						<div class="site-logo">
							<?php if (get_custom_logo()) { ?>
								<a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($turista_custom_logo[0]); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>"></a>
							<?php } else { ?>
								<a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/logo.png" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>"></a>
							<?php } ?>
						</div>
					</div><!--- END Col -->

					<div class="col-lg-10 col-md-9 col-sm-8">
						<div class="header_right">
							<nav id="main-menu" class="ml-auto">
								<?php turista_main_menu(); ?>
							</nav>
							<div id="mobile_menu"></div>
						</div>
					</div><!--- END Col -->
				</div><!--- END ROW -->
			</div><!--- END CONTAINER -->
		</div>
		<!-- END NAVBAR -->
	<?php } ?>
<?php
}

function turista_footer()
{
	global $turista;

	$turista_copywrite_text						 = '';

	if (isset($turista['turista_copywrite_text'])) {
		$turista_copywrite_text = $turista['turista_copywrite_text'];
	}

	if (isset($turista['turista_footer_social_opt'])) {
		$turista_footer_social_opt = $turista['turista_footer_social_opt'];
	}
?>

	<!-- START FOOTER -->
	<div class="footer">
		<div class="container">
			<div class="row">
				<?php if (is_active_sidebar('sidebar-2')) : ?>
					<div class="col-md-12 footer-top">
						<div class="row">
							<?php dynamic_sidebar('sidebar-2'); ?>
						</div>
					</div>
				<?php endif; ?>

				<div class="col-md-12 text-center">
					<div class="footer-bottom">
						<p class="copyright_text">
							<?php
							//if($turista_copywrite_text){
							//echo turista_wp_kses($turista_copywrite_text);
							//}else{
							//turista_wp_kses('Copyright @ 2020 <a href="#">Turista</a> all right reserved.' , 'turista');
							echo turista_wp_kses('Copyright © 2025 Videssihina.com. Powered by <a href="https://www.jetapp.lk" target="_blank">Jetapp</a>.');
							//}
							?>

						</p>
						<?php if ($turista_footer_social_opt == true) { ?>
							<ul class="foot_social_link">

								<?php foreach ((array) $turista_footer_social_opt as $social) {

									$icon = $url = '';

									if (isset($social['title']))
										$icon = $social['title'];

									if (isset($social['url']))
										$link = $social['url'];

								?>
									<li><a href="<?php echo esc_url($url); ?>"><i class="<?php echo esc_attr($icon); ?>"></i></a></li>
								<?php } ?>
							</ul>
						<?php } ?>
					</div>
				</div>
			</div><!--- END ROW -->
		</div><!--- END CONTAINER -->
	</div>
	<!-- END FOOTER -->

<?php
}

function turista_bannar_img_url()
{

	global $turista;

	$turista_theme_opt_banner_img						 = '';

	if (isset($turista['turista_theme_opt_banner_img']['url'])) {
		$turista_theme_opt_banner_img = $turista['turista_theme_opt_banner_img']['url'];
	}

	$turista_meta_banner_img = get_post_meta(get_the_ID(), '_turista_home_banner_img', true);
	$turista_default_banner_img = get_template_directory_uri() . '/assets/img/bg/section-bg.jpg';

	if ($turista_meta_banner_img) {
		return $turista_meta_banner_img;
	} elseif ($turista_theme_opt_banner_img) {
		return $turista_theme_opt_banner_img;
	} else {
		return $turista_default_banner_img;
	}
}

function turista_blog_banner()
{
	global $turista;

	$turista_blog_title						 = '';

	if (isset($turista['turista_blog_title'])) {
		$turista_blog_title = $turista['turista_blog_title'];
	}

?>

	<section class="page_banner" style="background-image: url(<?php echo esc_url(turista_bannar_img_url()); ?>);  background-size:cover; background-position: center center;">
		<div class="banner_overlay">
			<div class="container">
				<div class="row">
					<div class="col-md-12 text-center">
						<h1 class="section-blog-title">
							<?php if ($turista_blog_title) {
								echo esc_html($turista_blog_title);
							} else {
								echo esc_html__('Blog Post', 'turista');
							} ?>

						</h1>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
}

function turista_single_page_banner()
{

?>

	<section class="page_banner" style="background-image: url(<?php echo esc_url(turista_bannar_img_url()); ?>);  background-size:cover; background-position: center center;">
		<div class="banner_overlay">
			<div class="container">
				<div class="row">
					<div class="col-md-12 text-center">
						<h1 class="section-blog-title"><?php the_title(); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
}

function turista_archive_banner()
{

?>

	<section class="page_banner" style="background-image: url(<?php echo esc_url(turista_bannar_img_url()); ?>);  background-size:cover; background-position: center center;">
		<div class="banner_overlay">
			<div class="container">
				<div class="row">
					<div class="col-md-12 text-center">
						<h1 class="section-blog-title"><?php the_archive_title(); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
}

function turista_search_banner()
{

?>

	<section class="page_banner" style="background-image: url(<?php echo esc_url(turista_bannar_img_url()); ?>);  background-size:cover; background-position: center center;">
		<div class="banner_overlay">
			<div class="container">
				<div class="row">
					<div class="col-md-12 text-center">
						<h1 class="section-blog-title"><?php printf(esc_html__('Search Results for: %s', 'turista'), '<span>' . get_search_query() . '</span>'); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
}

function turista_404_banner()
{
	global $turista;

	$turista_404_title_text						 = '';

	if (isset($turista['turista_404_title_text'])) {
		$turista_404_title_text = $turista['turista_404_title_text'];
	}
?>

	<section class="page_banner" style="background-image: url(<?php echo esc_url(turista_bannar_img_url()); ?>);  background-size:cover; background-position: center center;">
		<div class="banner_overlay">
			<div class="container">
				<div class="row">
					<div class="col-md-12 text-center">
						<h1 class="section-blog-title">
							<?php if ($turista_404_title_text) {
								echo esc_html($turista_404_title_text);
							} else {
								echo esc_html__('404', 'turista');
							} ?>
						</h1>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
}

function turista_404_content()
{
	global $turista;

	$turista_404_page_title						 = '';
	$turista_404_page_descrption						 = '';

	if (isset($turista['turista_404_page_title'])) {
		$turista_404_page_title = $turista['turista_404_page_title'];
	}

	if (isset($turista['turista_404_page_descrption'])) {
		$turista_404_page_descrption = $turista['turista_404_page_descrption'];
	}
?>

	<h2>
		<?php if ($turista_404_page_title) {
			echo esc_html($turista_404_page_title);
		} else {
			echo esc_html__('404 error not found', 'turista');
		} ?>
	</h2>

	<p>
		<?php
		if ($turista_404_page_descrption) {
			echo esc_html($turista_404_page_descrption);
		} else {
			esc_html_e('It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'turista');
		}

		?>
	</p>

<?php
}
