<?php

/**
 *
 * Registering Google Fonts
 *
 */

function turista_google_fonts_url() {

  $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'turista' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Nunito:400,500,600,700&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }

    return $font_url;

}

/**
 * Enqueue scripts and styles.
 */
function turista_scripts() {
	global $turista;
	
	$turista_scroll_up_opt					 = '';
	
	if ( isset( $turista['turista_scroll_up_opt'] ) ) {
		$turista_scroll_up_opt = $turista['turista_scroll_up_opt'];
	}
	
	// All CSS Files	
	wp_enqueue_style( 'turista-google-fonts', turista_google_fonts_url(), array(), '1.0.0' );	
	
	wp_enqueue_style('bootstrap' , TURISTADIRPATH. '/assets/bootstrap/css/bootstrap.min.css');
	
	wp_enqueue_style('font-awesome' , TURISTADIRPATH. '/assets/fonts/font-awesome.min.css');
	
	wp_enqueue_style('themify-icons' , TURISTADIRPATH. '/assets/fonts/themify-icons.css');
	
	wp_enqueue_style('icofont' , TURISTADIRPATH. '/assets/fonts/icofont/icofont.css');

	wp_enqueue_style('owl-carousel' , TURISTADIRPATH. '/assets/owlcarousel/css/owl.carousel.css');
	
	wp_enqueue_style('owl-theme' , TURISTADIRPATH. '/assets/owlcarousel/css/owl.theme.css');
	
	wp_enqueue_style('slicknav' , TURISTADIRPATH. '/assets/css/slicknav.css');
	
	wp_enqueue_style('magnific-popup' , TURISTADIRPATH. '/assets/css/magnific-popup.css');
	
	wp_enqueue_style('slick' , TURISTADIRPATH. '/assets/css/slick.css');
	
	wp_enqueue_style('slick-theme' , TURISTADIRPATH. '/assets/css/slick-theme.css');
	
	wp_enqueue_style('aos' , TURISTADIRPATH. '/assets/css/aos.css');
	
	wp_enqueue_style('main-style' , TURISTADIRPATH. '/assets/css/style.css');
	
	wp_enqueue_style( 'turista-style', get_stylesheet_uri() );

	// All JS Files
	wp_enqueue_script( 'html5shiv', TURISTADIRPATH . '/js/html5shiv.min.js', array(), '3.7.2' );	
	wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 10' ); 	
	
	wp_enqueue_script( 'respond', TURISTADIRPATH . '/js/respond.min.js', array(), '1.4.2' );
	wp_script_add_data( 'respond', 'conditional', 'lt IE 10' );
	
	wp_enqueue_script( 'bootstrap', TURISTADIRPATH . '/assets/bootstrap/js/bootstrap.min.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'modernizr', TURISTADIRPATH . '/assets/js/modernizr-2.8.3.min.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'jquery-nav', TURISTADIRPATH . '/assets/js/jquery.nav.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'smooth-scroll', TURISTADIRPATH . '/assets/js/smooth-scroll.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'owl-carousel', TURISTADIRPATH . '/assets/owlcarousel/js/owl.carousel.min.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'jquery-slicknav', TURISTADIRPATH . '/assets/js/jquery.slicknav.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'jquery-stellar', TURISTADIRPATH . '/assets/js/jquery.stellar.min.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'jquery-inview', TURISTADIRPATH . '/assets/js/jquery.inview.min.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'magnific-popup', TURISTADIRPATH . '/assets/js/jquery.magnific-popup.js', array('jquery'), '54495', true );
	
	if($turista_scroll_up_opt == true){
		wp_enqueue_script( 'scrolltopcontrol', TURISTADIRPATH . '/assets/js/scrolltopcontrol.js', array('jquery'), '54495', true );	
	}
	
	wp_enqueue_script( 'slick', TURISTADIRPATH . '/assets/js/slick.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'aos', TURISTADIRPATH . '/assets/js/aos.js', array('jquery'), '54495', true );
	
	wp_enqueue_script( 'scripts', TURISTADIRPATH . '/assets/js/scripts.js', array('jquery'), '54495', true );
	
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'turista_scripts' );