<?php
/**
 * Turista functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Turista
 */

// Define
define( 'TURISTADIRPATH' , get_template_directory_uri());

if ( ! function_exists( 'turista_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function turista_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Turista, use a find and replace
		 * to change 'turista' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'turista', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		add_image_size( 'turista_image_1200_800', 1200,800, true );
		add_image_size( 'turista_image_1200_1000', 1200,1000, true );
		add_image_size( 'turista_image_185_100', 185,100, true );
		add_image_size( 'turista_image_100_100', 100,100, true );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'turista' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'turista_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 310,
			'width'       => 122,
			'flex-width'  => true,
			'flex-height' => true,
		) );
		
		add_theme_support( 'post-formats', array(
			'audio',
			'video',
		) );
		
		// Load regular editor styles into the new block-based editor.
		add_theme_support( 'editor-styles' );
		
		// Load default block styles.
		add_theme_support( 'wp-block-styles' );
	
		add_editor_style( array( 'assets/css/editor-style.css', turista_google_fonts_url() ) );		
			
	}
endif;
add_action( 'after_setup_theme', 'turista_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function turista_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'turista_content_width', 640 );
}
add_action( 'after_setup_theme', 'turista_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function turista_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'turista' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( '', 'turista' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget_title">',
		'after_title'   => '</h2>',
	) );	
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Sidebar', 'turista' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( '', 'turista' ),
		'before_widget' => '<div class="col-lg-3"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h3 class="fot-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'turista_widgets_init' );

/**
 * Main Menu
 */
function turista_main_menu() {
		wp_nav_menu( array(
		'theme_location'    => 'menu-1',
		'depth'             => 5,
		'container'         => false,
		'menu_class'        => 'ml-auto',
		'fallback_cb'       => 'turista_navwalker::fallback',
		
		)
	); 	
}

/**
 * Turista WP Kses
*/
 
function turista_wp_kses($val){
	return wp_kses($val, array(
	
	'p' => array(
		'class' =>array()
	),
	'span' => array(),
	'small' => array(),
	'div' => array(),
	'strong' => array(),
	'b' => array(),
	'br' => array(),
	'h1' => array(),
	'i' => array(
		'class' =>array()
	),	
	'ul' => array(
		'class' =>array()
	),	
	'ul' => array(
		'id' =>array()
	),	
	'li' => array(
		'class' =>array()
	),	
	'li' => array(
		'id' =>array()
	),
	'h2' => array(),
	'h3' => array(),
	'h4' => array(),
	'h5' => array(),
	'h6' => array(),
	'a'=> array('href' => array(),'target' => array()),
	'iframe'=> array('src' => array(),'height' => array(),'width' => array()),
	
	), '');
}

// comment list modify

function turista_comments($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>

<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">

	<div class="comment-item">
		<?php if(get_avatar($comment)){ ?>
			<div class="author_pic">
				<?php echo get_avatar( $comment, 200 ); ?>
			</div>
		<?php } ?>
		
		<div class="comment_text">
			<h4 class="com-author-name"><?php comment_author_link() ?></h4>
			<div class="date"><?php echo esc_html(get_comment_date('F j, Y')); ?> <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></div>
			<div class="comment-description">
				 <?php comment_text(); ?>
			</div>
			<?php if ($comment->comment_approved == '0') : ?>
				<p><em><?php esc_html_e('Your comment is awaiting moderation.','turista'); ?></em></p>
			<?php endif; ?>
		</div>
	</div>	
</li>


<?php } 

// comment box title change
add_filter( 'comment_form_defaults', 'turista_remove_comment_form_allowed_tags' );
function turista_remove_comment_form_allowed_tags( $defaults ) {

	$defaults['comment_notes_after'] = '';
	$defaults['comment_notes_before'] = '';
	return $defaults;

}

function turista_comment_reform ($arg) {

$arg['title_reply'] = esc_html__('Leave a comment','turista');
$arg['comment_field'] = '<div class="row"><div class="form-group col-md-12"><div class="form-textarea"><label for="comment" class="comment_label">Comment *</label> <br><textarea id="comment" class="comment_field form-control" name="comment" cols="77" rows="3" placeholder="'. esc_attr__("", "turista").'" aria-required="true"></textarea></div></div></div>';


return $arg;

}
add_filter('comment_form_defaults','turista_comment_reform');

// comment form modify

function turista_modify_comment_form_fields($fields){
	$commenter = wp_get_current_commenter();
	$req	   = get_option( 'require_name_email' );

	$fields['author'] = '<div class="row"><div class="form-group col-md-6"><div class="form-item"><label for="author" class="comment_label">Name *</label> <br> <input type="text" name="author" id="author" value="'. esc_attr( $commenter['comment_author'] ) .'" placeholder="'. esc_attr__("", "turista").'" size="22" tabindex="1"'. ( $req ? 'aria-required="true"' : '' ).' class="input-name form-control" /></div></div>';

	$fields['email'] = '<div class="form-group col-md-6"><div class="form-item"><label for="email" class="comment_label">Email *</label> <br><input type="text" name="email" id="email" value="'. esc_attr( $commenter['comment_author_email'] ) .'" placeholder="'.esc_attr__("", "turista").'" size="22" tabindex="2"'. ( $req ? 'aria-required="true"' : '' ).' class="input-email form-control"  /></div></div>';
	
	$fields['url'] = '<div class="form-group col-md-12"><div class="form-item"><label for="url" class="comment_label">Website </label> <br><input type="text" name="url" id="url" value="'. esc_attr( $commenter['comment_author_url'] ) .'" placeholder="'. esc_attr__("", "turista").'" size="22" tabindex="2"'. ( $req ? 'aria-required="false"' : '' ).' class="input-url form-control"  /></div></div></div>';

	return $fields;
}
add_filter('comment_form_default_fields','turista_modify_comment_form_fields');

// comment Move Field
function turista_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'turista_move_comment_field_to_bottom' );


// Modify search widget
function turista_my_search_form( $form ) {
	$form = '
		
			<div class="search_form">
				<form role="search" method="get" id="searchform" class="searchform" action="' . esc_url(home_url( '/' )) . '" >
					<input type="text" value="' . esc_attr(get_search_query()) . '" name="s" id="s" class="form-control" placeholder="' . esc_attr__('Enter Your Keyword' , 'turista') .'">
					<button type="submit" class="search-btn"><i class="icofont-search-1"></i></button>			
				</form>
			</div>
		
        ';
	return $form;
}
add_filter( 'get_search_form', 'turista_my_search_form' );

/**
 * Implement the Enqueue Files
 */
require get_template_directory() . '/inc/enqueue-files.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/**
* class-tgm-plugin-activation.php
*/
require get_template_directory() . '/inc/class-tgm-plugin-activation.php';
/**
* required-plugin.php
*/
require get_template_directory() . '/inc/required-plugin.php';

/**
* turista-functions.php
*/
require get_template_directory() . '/inc/turista-functions.php';

/**
* navwalker.php
*/
require get_template_directory() . '/inc/navwalker.php';

/**
* demo_install.php
*/
require get_template_directory() . '/inc/demo_install.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}


// Comment Excerpt

function turista_custom_excerpt_length( $length ) {
    return 30;
}
add_filter( 'excerpt_length', 'turista_custom_excerpt_length', 999 );

