<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaTourWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-tour';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Tour' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_tour',
			[
				'label' => esc_html__( 'Tour', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'tour_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Popular Tour Package',
			]
		);	
		
		$this->add_control(
			'tour_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'The Best Of Our All <br> Tour Packages',
			]
		);		
	
		
		$this->add_control(
			'tour_nub_post',
			[
				'label' => esc_html__( 'Number of Posts', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => '-1',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$tour_title = $this->get_settings_for_display( 'tour_title' );
		$tour_content = $this->get_settings_for_display( 'tour_content' );
		$tour_nub_post = $this->get_settings_for_display( 'tour_nub_post' );
		
		?>
		<!-- START SPECIAL PACKAGE -->
		<section id="special_package" class="special_package section-padding">
			<div class="container">
				<div class="row">
					<div class="col-md-12" data-aos="fade-up">
						<div class="section-title text-center">

							<span><?php echo turista_wp_kses($tour_title);?></span>
							<h2><?php echo turista_wp_kses($tour_content);?></h2>	
						</div>
					</div><!-- END COL -->
				</div><!-- END ROW -->		
				
				<div class="row text-left">
					<div class="col-md-12" data-aos="fade-up">
						<div id="package-slider">
			
							
				<?php
					// WP_Query arguments
					$args = array(
						'post_type'              => array( 'tour' ),
						'posts_per_page'         => $tour_nub_post,
					);

					// The Query
					$turista_tour_query = new WP_Query( $args );

					// The Loop
					if ( $turista_tour_query->have_posts() ) {
						while ( $turista_tour_query->have_posts() ) {
							$turista_tour_query->the_post();					
							$turista_t_price = get_post_meta(get_the_ID(), '_turista_t_price', true);
							$turista_t_period = get_post_meta(get_the_ID(), '_turista_t_period', true);
							$turista_tour_button_text = get_post_meta(get_the_ID(), '_turista_tour_button_text', true);
							$turista_tour_rating = get_post_meta(get_the_ID(), '_turista_tour_rating', true);
						?>
	

							<div class="single_package"> 
								<div class="pack_image">
									<?php the_post_thumbnail('turista_image_1200_800');?>		
								</div>
								
								<div class="package-hover">
									<div class="pull-left"><h5><?php the_title();?></h5></div>
									<div class="pull-right"><span class="pack_price"><?php echo esc_html($turista_t_price);?></span></div>
									<div class="clearfix"></div>
									<div class="rating">
										<?php if($turista_tour_rating == '2'){
											echo '
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
											';
										}elseif($turista_tour_rating == '3'){
											echo '
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
											';
										}elseif($turista_tour_rating == '4'){
											echo '
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
											';
										}elseif($turista_tour_rating == '5'){
											echo '
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
												<i class="fa fa-star"></i>
											';
										}else{
											echo '
												<i class="fa fa-star"></i>
											';
										}?>

									</div>									
									<span class="time_zone"><i class="icofont-wall-clock"></i> <?php echo esc_html($turista_t_period);?></span>
									<?php the_content();?>									
									<a href="<?php the_permalink();?>" class="btn-bg"><?php echo esc_html($turista_tour_button_text);?></a>
								</div>
							</div><!-- END SINGLE PACKAGE -->							
						<?php
						}
					} else {
						// no posts found
					}

					// Restore original Post Data
					wp_reset_postdata();
				?>				
							

						</div>
					</div><!-- END COL -->
				</div><!-- END ROW -->
			</div><!-- END CONTAINER -->
		</section>
		<!-- END SPECIAL PACKAGE -->
		
		
<?php
	}

}
