<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaTourGalleryWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-tour-gallery';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Tour Gallery' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_tour_gallery',
			[
				'label' => esc_html__( 'Tour Gallery', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'tour_gallery_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Tour Gallery',
			]
		);	
		
		$this->add_control(
			'tour_gallery_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'Best Tourist\'s Shared <br> Photos',
			]
		);		
	
		
		$this->add_control(
			'tour_gallery_nub_post',
			[
				'label' => esc_html__( 'Number of Posts', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => '-1',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$tour_gallery_title = $this->get_settings_for_display( 'tour_gallery_title' );
		$tour_gallery_content = $this->get_settings_for_display( 'tour_gallery_content' );
		$tour_gallery_nub_post = $this->get_settings_for_display( 'tour_gallery_nub_post' );
		
		?>
		
		<!-- START GALLERY -->
		<section id="gallery" class="our_gallery">
			<div class="container-fluid">
				<div class="row">
					<div class="col-md-12" data-aos="fade-up">
						<div class="section-title text-center">
							<span><?php echo turista_wp_kses($tour_gallery_title);?></span>
							<h2><?php echo turista_wp_kses($tour_gallery_content);?></h2>							
						</div>
					</div><!-- END COL -->
				</div><!-- END ROW -->	
				
				<div class="row">
					<div class="col-md-12 padding_0">
						<div id="gallery-slider">
						
				<?php
					// WP_Query arguments
					$args = array(
						'post_type'              => array( 'tour_gallery' ),
						'posts_per_page'         => $tour_gallery_nub_post,
					);

					// The Query
					$turista_tour_gallery_query = new WP_Query( $args );

					// The Loop
					if ( $turista_tour_gallery_query->have_posts() ) {
						while ( $turista_tour_gallery_query->have_posts() ) {
							$turista_tour_gallery_query->the_post();					
							$turista_tour_gallery_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'turista_image_1200_1000');
						?>
	
							<div class="single_gallery">
								<img src="<?php echo esc_url($turista_tour_gallery_image['0']);?>" class="img-gallery" alt="<?php echo esc_attr(get_the_title());?>" />										
								<a class="gallery_enlarge_icon" href="<?php echo esc_url($turista_tour_gallery_image['0']);?>" title="<?php echo esc_attr(get_the_title())?>"><i class="icofont-resize"></i></a>
								<h4><?php the_title();?></h4>
							</div><!-- END SINGLE GALLERY -->						
						<?php
						}
					} else {
						// no posts found
					}

					// Restore original Post Data
					wp_reset_postdata();
				?>	
				
						</div>
					</div><!-- END COL -->
				</div><!-- END ROW -->
			</div><!-- END CONTAINER -->
		</section>
		<!-- END GALLERY -->		
		
<?php
	}

}
