<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaTestimonialsWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-testimonials';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Testimonials' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_testimonials',
			[
				'label' => esc_html__( 'Testimonials', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'testimonials_bg_img',
			[
				'label' => esc_html__( 'Background Image', 'turista' ),
				'type' => \Elementor\Controls_Manager::MEDIA ,
			]
		);	
		
		$this->add_control(
			'testimonials_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Testimonials',
			]
		);		
		
		$this->add_control(
			'testimonials_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'What our Happy Customers <br>Say About Us',
			]
		);			
		
		$this->add_control(
			'testimonials_nub_post',
			[
				'label' => esc_html__( 'Number of Posts', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => '-1',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$testimonials_bg_img = $this->get_settings_for_display( 'testimonials_bg_img' )['url'];
		$testimonials_title = $this->get_settings_for_display( 'testimonials_title' );
		$testimonials_content = $this->get_settings_for_display( 'testimonials_content' );
		$testimonials_nub_post = $this->get_settings_for_display( 'testimonials_nub_post' );
		
		?>

		<!-- START TESTIMONIAL -->
		<section class="testimonial" style="background-image: url(<?php echo esc_url($testimonials_bg_img);?>);">
			<div class="overlay section-padding">
				<div class="container">
					<div class="row">
						<div class="col-md-12" data-aos="fade-up">
							<div class="section-title text-center white-title">
								<span><?php echo esc_html($testimonials_title);?></span>
								<h2><?php echo turista_wp_kses($testimonials_content);?></h2>							
							</div>
						</div><!-- END COL -->
					</div><!-- END ROW -->	
					
					<div class="row">
						<div class="col-md-12 d-block mx-auto text-center">
							<div id="testimonial-slider" class="owl-carousel">
							
							<?php
							// WP_Query arguments
							$args = array(
								'post_type'              => array( 'testimonials' ),
								'posts_per_page'         => $testimonials_nub_post,
							);

							// The Query
							$turista_testimonials_query = new WP_Query( $args );

							// The Loop
							if ( $turista_testimonials_query->have_posts() ) {
								while ( $turista_testimonials_query->have_posts() ) {
									$turista_testimonials_query->the_post();
									$turista_test_rating = get_post_meta(get_the_ID(), '_turista_test_rating', true);
									$turista_test_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'turista_image_100_100');
									?>
								<div class="single-testimonial">								
									<div class="testimonial-content">										
										<?php the_content();?>																	
									</div>
							
									<div class="testimonial-bottom">
										<img src="<?php echo esc_url($turista_test_image[0]);?>" width="50" alt="review image">
										<h3 class="title"><?php the_title();?></h3>
										<div class="test-rating">
											<ul class="list-inline">
												<li class="list-inline-item">								

												<?php if($turista_test_rating == '2'){
													echo '
														<i class="icofont-star"></i>									
														<i class="icofont-star"></i>
													';
												}elseif($turista_test_rating == '3'){
													echo '
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
													';
												}elseif($turista_test_rating == '4'){
													echo '
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
													';
												}elseif($turista_test_rating == '5'){
													echo '
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
														<i class="icofont-star"></i>
													';
												}else{
													echo '
														<i class="icofont-star"></i>
													';
												}?>													
												</li>
											</ul>
										</div>
									</div>											
								</div><!-- END single Testimonials -->								
								<?php	
									// do something
								}
							} else {
								// no posts found
							}

							// Restore original Post Data
							wp_reset_postdata();
							?>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- END TESTIMONIAL -->
<?php
	}

}
