<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaSingleChooseWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-single-choose';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Single Choose' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_single_choose',
			[
				'label' => esc_html__( 'Single Choose', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	
		$this->add_control(
			'choose_icon',
			[
				'label' => esc_html__( 'Icon', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'icofont-package',
			]
		);	
			
		$this->add_control(
			'choose_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Exclusive Packages',
			]
		);	
		
		$this->add_control(
			'choose_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'Lorem ipsum dolor sit amet consectetur adipisicing',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$choose_icon = $this->get_settings_for_display( 'choose_icon' );
		$choose_title = $this->get_settings_for_display( 'choose_title' );
		$choose_content = $this->get_settings_for_display( 'choose_content' );
		
		?>


		<div class="single-choose">
			<i class="<?php echo esc_attr($choose_icon);?>"></i>
			<h4><?php echo turista_wp_kses($choose_title);?></h4>
			<p><?php echo turista_wp_kses($choose_content);?></p>
		</div>

					
<?php
	}

}
