<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaCounterUpWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-counter-up';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Counter Up' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_counter_up',
			[
				'label' => esc_html__( 'Counter Up', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'counter_icon', [
				'label' => esc_html__( 'Icon', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);	

		$repeater->add_control(
			'counter_number', [
				'label' => esc_html__( 'Number', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		

		$repeater->add_control(
			'counter_text', [
				'label' => esc_html__( 'Counter Text', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'counter_up_list',
			[
				'label' => esc_html__
				( 'Counter Up List', 'turista' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[																		
						'counter_icon' => turista_wp_kses('icofont-users-alt-3'),					
						'counter_number' => turista_wp_kses('32652'),									
						'counter_text' => turista_wp_kses('Happy Customers'),					
					],
		
				],
			]
		);	
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$counter_up_list = $this->get_settings_for_display( 'counter_up_list' );		
		?>



		<!-- START COUNTER -->
		<section class="complete-project-area counter_feature">
			<div class="container">
				<div class="row">
					<?php
						foreach ($counter_up_list as $item ) { ?>	
						
						<div class="col-md-3 col-sm-6 col-xs-12 no-padding">
							<div class="single-project-complete">
								<i class="<?php echo esc_attr($item['counter_icon']);?>"></i>
								<h2 class="counter-num"><?php echo esc_attr($item['counter_number']);?></h2>
								<h3><?php echo esc_attr($item['counter_text']);?></h3>
							</div>
						</div><!-- END COL -->
								
					<?php } ?>	
		
				</div><!-- END ROW -->
			</div><!-- END CONTAINER -->
		</section>
		<!-- END COUNTER -->
					
<?php
	}

}
