<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaBlogWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-blog';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Blog' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_blog',
			[
				'label' => esc_html__( 'Blog', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'blog_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Latest Blog Posts',
			]
		);	
		
		$this->add_control(
			'blog_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'Our Latest Article <br> For Travellers',
			]
		);		
	
		
		$this->add_control(
			'blog_nub_post',
			[
				'label' => esc_html__( 'Number of Posts', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => '3',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$blog_title = $this->get_settings_for_display( 'blog_title' );
		$blog_content = $this->get_settings_for_display( 'blog_content' );
		$blog_nub_post = $this->get_settings_for_display( 'blog_nub_post' );
		
		?>

		<!-- START BLOG -->
		<section id="blog" class="blog_section">						
			<div class="container">
				<div class="row">
					<div class="col-md-12" data-aos="fade-up">
						<div class="section-title text-center">
							<span><?php echo turista_wp_kses($blog_title);?></span>
							<h2><?php echo turista_wp_kses($blog_content);?></h2>							
						</div>
					</div><!-- END COL -->
				</div><!-- END ROW -->		
				
				<div class="row" data-aos="fade-up">

						
				<?php
					// WP_Query arguments
					$args = array(
						'post_type'              => array( 'post' ),
						'posts_per_page'         => $blog_nub_post,
					);

					// The Query
					$turista_blog_query = new WP_Query( $args );

					// The Loop
					if ( $turista_blog_query->have_posts() ) {
						while ( $turista_blog_query->have_posts() ) {
							$turista_blog_query->the_post();					
							$turista_blog_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'turista_image_1200_800');
						?>
	
							<div class="col-lg-4 col-md-6">
								<div class="single_blog">
									<?php if(has_post_thumbnail()){ ?>
										<div class="blog_image">
											<img class="blog-photo" alt="<?php echo esc_attr(get_the_title());?>" src="<?php echo esc_url($turista_blog_image['0']);?>"/>
										</div>
									<?php } ?>
									<div class="blog-text">	
										<h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>		
										<div class="post-meta">	
											<span>
												<i class="icofont-clock-time"></i> <?php echo get_the_time('d M Y');?>
											</span>	

											<span>
												<i class="icofont-comment"></i> <?php comments_popup_link( '0 Comments', '1 Comment ', '% Comments ', 'comments-link', ' 0 Comments '); ?>
											</span>
										</div>	
									</div>							
								</div>
							</div><!--- END COL -->							
						<?php
						}
					} else {
						// no posts found
					}

					// Restore original Post Data
					wp_reset_postdata();
				?>					


				</div><!--- END ROW -->
			</div><!--- END CONTAINER -->
		</section> 
		<!-- END BLOG -->		
		
<?php
	}

}
