<?php

if ( ! function_exists('turista_special_tour') ) {

// Register Special Tour Post Type
function turista_special_tour() {

	$labels = array(
		'name'                  => esc_html_x( 'Special Tour', 'Post Type General Name', 'turista' ),
		'singular_name'         => esc_html_x( 'Special Tour', 'Post Type Singular Name', 'turista' ),
		'menu_name'             => esc_html__( 'Special Tour', 'turista' ),
		'name_admin_bar'        => esc_html__( 'Special Tour', 'turista' ),
		'archives'              => esc_html__( 'Item Archives', 'turista' ),
		'attributes'            => esc_html__( 'Item Attributes', 'turista' ),
		'parent_item_colon'     => esc_html__( 'Parent Item:', 'turista' ),
		'all_items'             => esc_html__( 'All Items', 'turista' ),
		'add_new_item'          => esc_html__( 'Add New Item', 'turista' ),
		'add_new'               => esc_html__( 'Add New', 'turista' ),
		'new_item'              => esc_html__( 'New Item', 'turista' ),
		'edit_item'             => esc_html__( 'Edit Item', 'turista' ),
		'update_item'           => esc_html__( 'Update Item', 'turista' ),
		'view_item'             => esc_html__( 'View Item', 'turista' ),
		'view_items'            => esc_html__( 'View Items', 'turista' ),
		'search_items'          => esc_html__( 'Search Item', 'turista' ),
		'not_found'             => esc_html__( 'Not found', 'turista' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'turista' ),
		'featured_image'        => esc_html__( 'Featured Image', 'turista' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'turista' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'turista' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'turista' ),
		'insert_into_item'      => esc_html__( 'Insert into item', 'turista' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'turista' ),
		'items_list'            => esc_html__( 'Items list', 'turista' ),
		'items_list_navigation' => esc_html__( 'Items list navigation', 'turista' ),
		'filter_items_list'     => esc_html__( 'Filter items list', 'turista' ),
	);
	$args = array(
		'label'                 => esc_html__( 'Special Tour', 'turista' ),
		'description'           => esc_html__( 'Post Type Description', 'turista' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'   => 'dashicons-clipboard',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'special_tour', $args );

}
add_action( 'init', 'turista_special_tour', 0 );

}

if ( ! function_exists('turista_tour') ) {

// Register Tour Post Type
function turista_tour() {

	$labels = array(
		'name'                  => esc_html_x( 'Tour', 'Post Type General Name', 'turista' ),
		'singular_name'         => esc_html_x( 'Tour', 'Post Type Singular Name', 'turista' ),
		'menu_name'             => esc_html__( 'Tour', 'turista' ),
		'name_admin_bar'        => esc_html__( 'Tour', 'turista' ),
		'archives'              => esc_html__( 'Item Archives', 'turista' ),
		'attributes'            => esc_html__( 'Item Attributes', 'turista' ),
		'parent_item_colon'     => esc_html__( 'Parent Item:', 'turista' ),
		'all_items'             => esc_html__( 'All Items', 'turista' ),
		'add_new_item'          => esc_html__( 'Add New Item', 'turista' ),
		'add_new'               => esc_html__( 'Add New', 'turista' ),
		'new_item'              => esc_html__( 'New Item', 'turista' ),
		'edit_item'             => esc_html__( 'Edit Item', 'turista' ),
		'update_item'           => esc_html__( 'Update Item', 'turista' ),
		'view_item'             => esc_html__( 'View Item', 'turista' ),
		'view_items'            => esc_html__( 'View Items', 'turista' ),
		'search_items'          => esc_html__( 'Search Item', 'turista' ),
		'not_found'             => esc_html__( 'Not found', 'turista' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'turista' ),
		'featured_image'        => esc_html__( 'Featured Image', 'turista' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'turista' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'turista' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'turista' ),
		'insert_into_item'      => esc_html__( 'Insert into item', 'turista' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'turista' ),
		'items_list'            => esc_html__( 'Items list', 'turista' ),
		'items_list_navigation' => esc_html__( 'Items list navigation', 'turista' ),
		'filter_items_list'     => esc_html__( 'Filter items list', 'turista' ),
	);
	$args = array(
		'label'                 => esc_html__( 'Tour', 'turista' ),
		'description'           => esc_html__( 'Post Type Description', 'turista' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'   => 'dashicons-lightbulb',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'tour', $args );

}
add_action( 'init', 'turista_tour', 0 );

}

if ( ! function_exists('turista_client') ) {

// Register Client Post Type
function turista_client() {

	$labels = array(
		'name'                  => esc_html_x( 'Client', 'Post Type General Name', 'turista' ),
		'singular_name'         => esc_html_x( 'Client', 'Post Type Singular Name', 'turista' ),
		'menu_name'             => esc_html__( 'Client', 'turista' ),
		'name_admin_bar'        => esc_html__( 'Client', 'turista' ),
		'archives'              => esc_html__( 'Item Archives', 'turista' ),
		'attributes'            => esc_html__( 'Item Attributes', 'turista' ),
		'parent_item_colon'     => esc_html__( 'Parent Item:', 'turista' ),
		'all_items'             => esc_html__( 'All Items', 'turista' ),
		'add_new_item'          => esc_html__( 'Add New Item', 'turista' ),
		'add_new'               => esc_html__( 'Add New', 'turista' ),
		'new_item'              => esc_html__( 'New Item', 'turista' ),
		'edit_item'             => esc_html__( 'Edit Item', 'turista' ),
		'update_item'           => esc_html__( 'Update Item', 'turista' ),
		'view_item'             => esc_html__( 'View Item', 'turista' ),
		'view_items'            => esc_html__( 'View Items', 'turista' ),
		'search_items'          => esc_html__( 'Search Item', 'turista' ),
		'not_found'             => esc_html__( 'Not found', 'turista' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'turista' ),
		'featured_image'        => esc_html__( 'Featured Image', 'turista' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'turista' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'turista' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'turista' ),
		'insert_into_item'      => esc_html__( 'Insert into item', 'turista' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'turista' ),
		'items_list'            => esc_html__( 'Items list', 'turista' ),
		'items_list_navigation' => esc_html__( 'Items list navigation', 'turista' ),
		'filter_items_list'     => esc_html__( 'Filter items list', 'turista' ),
	);
	$args = array(
		'label'                 => esc_html__( 'Client', 'turista' ),
		'description'           => esc_html__( 'Post Type Description', 'turista' ),
		'labels'                => $labels,
		'supports'              => array( 'title','thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'   => 'dashicons-nametag',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'client', $args );

}
add_action( 'init', 'turista_client', 0 );

}

if ( ! function_exists('turista_tour_gallery') ) {

// Register Tour Gallery Post Type
function turista_tour_gallery() {

	$labels = array(
		'name'                  => esc_html_x( 'Tour Gallery', 'Post Type General Name', 'turista' ),
		'singular_name'         => esc_html_x( 'Tour Gallery', 'Post Type Singular Name', 'turista' ),
		'menu_name'             => esc_html__( 'Tour Gallery', 'turista' ),
		'name_admin_bar'        => esc_html__( 'Tour Gallery', 'turista' ),
		'archives'              => esc_html__( 'Item Archives', 'turista' ),
		'attributes'            => esc_html__( 'Item Attributes', 'turista' ),
		'parent_item_colon'     => esc_html__( 'Parent Item:', 'turista' ),
		'all_items'             => esc_html__( 'All Items', 'turista' ),
		'add_new_item'          => esc_html__( 'Add New Item', 'turista' ),
		'add_new'               => esc_html__( 'Add New', 'turista' ),
		'new_item'              => esc_html__( 'New Item', 'turista' ),
		'edit_item'             => esc_html__( 'Edit Item', 'turista' ),
		'update_item'           => esc_html__( 'Update Item', 'turista' ),
		'view_item'             => esc_html__( 'View Item', 'turista' ),
		'view_items'            => esc_html__( 'View Items', 'turista' ),
		'search_items'          => esc_html__( 'Search Item', 'turista' ),
		'not_found'             => esc_html__( 'Not found', 'turista' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'turista' ),
		'featured_image'        => esc_html__( 'Featured Image', 'turista' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'turista' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'turista' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'turista' ),
		'insert_into_item'      => esc_html__( 'Insert into item', 'turista' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'turista' ),
		'items_list'            => esc_html__( 'Items list', 'turista' ),
		'items_list_navigation' => esc_html__( 'Items list navigation', 'turista' ),
		'filter_items_list'     => esc_html__( 'Filter items list', 'turista' ),
	);
	$args = array(
		'label'                 => esc_html__( 'Tour Gallery', 'turista' ),
		'description'           => esc_html__( 'Post Type Description', 'turista' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'   => 'dashicons-format-gallery',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'tour_gallery', $args );

}
add_action( 'init', 'turista_tour_gallery', 0 );

}

if ( ! function_exists('turista_testimonials') ) {

// Register Testimonial Post Type
function turista_testimonials() {

	$labels = array(
		'name'                  => esc_html_x( 'Testimonials', 'Post Type General Name', 'turista' ),
		'singular_name'         => esc_html_x( 'Testimonial', 'Post Type Singular Name', 'turista' ),
		'menu_name'             => esc_html__( 'Testimonials', 'turista' ),
		'name_admin_bar'        => esc_html__( 'Testimonials', 'turista' ),
		'archives'              => esc_html__( 'Item Archives', 'turista' ),
		'attributes'            => esc_html__( 'Item Attributes', 'turista' ),
		'parent_item_colon'     => esc_html__( 'Parent Item:', 'turista' ),
		'all_items'             => esc_html__( 'All Items', 'turista' ),
		'add_new_item'          => esc_html__( 'Add New Item', 'turista' ),
		'add_new'               => esc_html__( 'Add New', 'turista' ),
		'new_item'              => esc_html__( 'New Item', 'turista' ),
		'edit_item'             => esc_html__( 'Edit Item', 'turista' ),
		'update_item'           => esc_html__( 'Update Item', 'turista' ),
		'view_item'             => esc_html__( 'View Item', 'turista' ),
		'view_items'            => esc_html__( 'View Items', 'turista' ),
		'search_items'          => esc_html__( 'Search Item', 'turista' ),
		'not_found'             => esc_html__( 'Not found', 'turista' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'turista' ),
		'featured_image'        => esc_html__( 'Featured Image', 'turista' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'turista' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'turista' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'turista' ),
		'insert_into_item'      => esc_html__( 'Insert into item', 'turista' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'turista' ),
		'items_list'            => esc_html__( 'Items list', 'turista' ),
		'items_list_navigation' => esc_html__( 'Items list navigation', 'turista' ),
		'filter_items_list'     => esc_html__( 'Filter items list', 'turista' ),
	);
	$args = array(
		'label'                 => esc_html__( 'Testimonial', 'turista' ),
		'description'           => esc_html__( 'Post Type Description', 'turista' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'   => 'dashicons-format-chat',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'testimonials', $args );

}
add_action( 'init', 'turista_testimonials', 0 );

}