<?php


add_action( 'cmb2_init', 'turista_metabox_options' );

function turista_metabox_options(){
	// Start with an underscore to hide fields from custom fields list
	$prefix = '_turista_';

	// Page Options	
	$cmb2_post_page_opt = new_cmb2_box( array(
		'id'           => $prefix . 'page_option',
		'title'        => esc_html__( 'Options', 'turista' ),
		'object_types' => array(  'page' , 'post', 'product'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );
	
	$cmb2_post_page_opt->add_field( array(
	    'name'             => esc_html__('Page Layout' , 'turista'),
	    'id'               => $prefix .'page_layout',
		'type'             => 'select',
		'desc'    => esc_html__('Select here' , 'turista'),
		'options'          => array(
			'1' => esc_html__( 'Left Sidebar', 'turista' ),
			'2'   => esc_html__( 'Right Sidebar', 'turista' ),
			'3'   => esc_html__( 'Full Width', 'turista' ),
			'4'   => esc_html__( 'Full Width Stretch', 'turista' ),
		),
		'default'             => '2',
	) );
	
	
	$cmb2_post_page_opt->add_field( array(
	    'name'             => esc_html__('Hide Banner ' , 'turista'),
	    'id'               => $prefix .'hide_banner',
		'desc'    => esc_html__('Check/Uncheck here' , 'turista'),
	    'type'    => 'checkbox',
	) );
	
	$cmb2_post_page_opt->add_field( array(
	    'id'               => $prefix .'home_banner_img',
		'name'             => esc_html__('Banner Background Image' , 'turista'),
	    'desc'             => esc_html__( 'upload image here ','turista' ),
		 'type'             => 'file',
	) );	
	

	//Post Options	
	$cmb2_post_options = new_cmb2_box( array(
		'id'           => $prefix . 'posts_option',
		'title'        => esc_html__( 'Post Options', 'turista' ),
		'object_types' => array( 'post'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );	
	
	
	$cmb2_post_options->add_field( array(
	    'name'             => esc_html__('Audio / Video Post Embed Code ' , 'turista'),
	    'id'               => $prefix .'vid_post_title',
	    'type'    => 'title',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => esc_html__('Embed Code' , 'turista'),
	    'id'               => $prefix .'embed_code',
		'desc'    => esc_html__('enter embed code here' , 'turista'),
	    'type'    => 'textarea_code',
	) );
	
	//Special Tour Options	
	$turista_special_tour_options = new_cmb2_box( array(
		'id'           => $prefix . 'special_tour_opt',
		'title'        => esc_html__( 'Special Tour Options', 'turista' ),
		'object_types' => array( 'special_tour'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );	

	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Price' , 'turista'),
	    'id'               => $prefix .'spt_price',
		'desc'    => esc_html__('enter price here' , 'turista'),
	    'type'    => 'text',
	    'default'    => 'From $955',
	) );	
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Period' , 'turista'),
	    'id'               => $prefix .'spt_period',
		'desc'    => esc_html__('write period here' , 'turista'),
	    'type'    => 'text',
	    'default'    => '5 days - 4 night',
	) );
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Single Page Title' , 'turista'),
	    'id'               => $prefix .'spt_single_page_title',
		'desc'    => esc_html__('write text here' , 'turista'),
	    'type'    => 'text',
	    'default'    => 'Special London Tour',
	) );	
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Gallery Images' , 'turista'),
	    'id'               => $prefix .'spt_gallery_images',
		'desc'    => esc_html__('upload images here' , 'turista'),
	    'type'    => 'file_list',
	) );
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Google Map Title' , 'turista'),
	    'id'               => $prefix .'spt_google_map_title',
		'desc'    => esc_html__('write text here' , 'turista'),
	    'type'    => 'text',
	    'default'    => 'Tour Location',
	) );	
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Google Map' , 'turista'),
	    'id'               => $prefix .'spt_google_map',
		'desc'    => esc_html__('enter google here' , 'turista'),
	    'type'    => 'textarea',
	) );	
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Contact Form Title' , 'turista'),
	    'id'               => $prefix .'spt_cont_form_title',
		'desc'    => esc_html__('wirte title here' , 'turista'),
	    'type'    => 'text',
		'default'    => 'Tour Booking',
				
	) );	
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Contact Form Shortcode' , 'turista'),
	    'id'               => $prefix .'spt_cont_form_code',
		'desc'    => esc_html__('enter shortcode here' , 'turista'),
	    'type'    => 'text',
	) );
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Related Tour Sub Title' , 'turista'),
	    'id'               => $prefix .'spt_related_subtitle',
		'desc'    => esc_html__('wirte title here' , 'turista'),
	    'type'    => 'text',
		'default'    => 'Related Packages',
				
	) );		
	
	$turista_special_tour_options->add_field( array(
	    'name'             => esc_html__('Related Tour Title' , 'turista'),
	    'id'               => $prefix .'spt_related_title',
		'desc'    => esc_html__('wirte title here' , 'turista'),
	    'type'    => 'textarea',
		'default'    => 'The Best Of Our All <br>Tour Packages',
				
	) );
	
	//Tour Options	
	$turista_tour_options = new_cmb2_box( array(
		'id'           => $prefix . 'tour_opt',
		'title'        => esc_html__( 'Tour Options', 'turista' ),
		'object_types' => array( 'tour'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );	

	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Price' , 'turista'),
	    'id'               => $prefix .'t_price',
		'desc'    => esc_html__('enter price here' , 'turista'),
	    'type'    => 'text',
	    'default'    => '$236',
	) );
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Period' , 'turista'),
	    'id'               => $prefix .'t_period',
		'desc'    => esc_html__('write period here' , 'turista'),
	    'type'    => 'text',
	    'default'    => '5 days - 4 night',
	) );
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Rating' , 'turista'),
	    'id'               => $prefix .'tour_rating',
		'type'             => 'select',
		'options'           =>  array(
			'1'             => esc_html__('1' , 'turista'),
			'2'             => esc_html__('2' , 'turista'),
			'3'             => esc_html__('3' , 'turista'),
			'4'             => esc_html__('4' , 'turista'),
			'5'             => esc_html__('5' , 'turista'),
		),
		'default'  => '5',
	) );
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Single Page Title' , 'turista'),
	    'id'               => $prefix .'single_page_title',
		'desc'    => esc_html__('write text here' , 'turista'),
	    'type'    => 'text',
	    'default'    => 'Special London Tour',
	) );	
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Gallery Images' , 'turista'),
	    'id'               => $prefix .'tour_gallery_images',
		'desc'    => esc_html__('upload images here' , 'turista'),
	    'type'    => 'file_list',
	) );
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Google Map Title' , 'turista'),
	    'id'               => $prefix .'google_map_title',
		'desc'    => esc_html__('write text here' , 'turista'),
	    'type'    => 'text',
	    'default'    => 'Tour Location',
	) );	
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Google Map' , 'turista'),
	    'id'               => $prefix .'google_map',
		'desc'    => esc_html__('enter google here' , 'turista'),
	    'type'    => 'textarea',
	) );	
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Contact Form Title' , 'turista'),
	    'id'               => $prefix .'cont_form_title',
		'desc'    => esc_html__('wirte title here' , 'turista'),
	    'type'    => 'text',
		'default'    => 'Tour Booking',
				
	) );	
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Contact Form Shortcode' , 'turista'),
	    'id'               => $prefix .'cont_form_code',
		'desc'    => esc_html__('enter shortcode here' , 'turista'),
	    'type'    => 'text',
	) );
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Button Text' , 'turista'),
	    'id'               => $prefix .'tour_button_text',
		'desc'    => esc_html__('write button here' , 'turista'),
	    'type'    => 'text',
	    'default'    => 'Book Now',
	) );	
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Related Tour Sub Title' , 'turista'),
	    'id'               => $prefix .'related_tour_subtitle',
		'desc'    => esc_html__('wirte title here' , 'turista'),
	    'type'    => 'text',
		'default'    => 'Related Packages',
				
	) );		
	
	$turista_tour_options->add_field( array(
	    'name'             => esc_html__('Related Tour Title' , 'turista'),
	    'id'               => $prefix .'related_tour_title',
		'desc'    => esc_html__('wirte title here' , 'turista'),
	    'type'    => 'textarea',
		'default'    => 'The Best Of Our All <br>Tour Packages',
				
	) );	
	
	//Start Clients Options
	
	$turista_clients = new_cmb2_box( array(
		'id'           => $prefix . 'clients_options',
		'title'        => esc_html__( 'Clients Info', 'turista' ),
		'object_types' => array( 'client'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );
	
	$turista_clients->add_field( array(
	    'name'             => esc_html__('Website Address' , 'turista'),
	    'id'               => $prefix .'client_url',
		'type'             => 'text',
		'default'             => '#',
	) );	
	

	//Start Testimonials Options
	$turista_testimonial = new_cmb2_box( array(
		'id'           => $prefix . 'testimonials_options',
		'title'        => esc_html__( 'Testimonials Info', 'turista' ),
		'object_types' => array( 'testimonials'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );
	
	
	$turista_testimonial->add_field( array(
	    'name'             => esc_html__('Rating' , 'turista'),
	    'id'               => $prefix .'test_rating',
		'type'             => 'select',
		'options'           =>  array(
			'1'             => esc_html__('1' , 'turista'),
			'2'             => esc_html__('2' , 'turista'),
			'3'             => esc_html__('3' , 'turista'),
			'4'             => esc_html__('4' , 'turista'),
			'5'             => esc_html__('5' , 'turista'),
		),
		'default'             => '5',
	) );	
	

}