<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaTitleWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-title';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Title' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	
		$this->add_control(
			'sec_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Why Choose Us?',
			]
		);	
		
		$this->add_control(
			'sec_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'Every Time We Provide <br> best Service',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$sec_title = $this->get_settings_for_display( 'sec_title' );
		$sec_content = $this->get_settings_for_display( 'sec_content' );
		
		?>


		<div class="section-title text-center" data-aos="fade-up">
			<span><?php echo turista_wp_kses($sec_title);?></span>
			<h2><?php echo turista_wp_kses($sec_content);?></h2>							
		</div>

			
<?php
	}

}
