<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaSpecialTourWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-special-tour';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Special Tour' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_special_tour',
			[
				'label' => esc_html__( 'Special Tour', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'sptour_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Popular Destinations',
			]
		);	
		
		$this->add_control(
			'sptour_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => 'Travel Most Popular Place <br> In The World',
			]
		);		
		
		$this->add_control(
			'sptour_nub_post',
			[
				'label' => esc_html__( 'Number of Posts', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => '6',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$sptour_title = $this->get_settings_for_display( 'sptour_title' );
		$sptour_content = $this->get_settings_for_display( 'sptour_content' );
		$sptour_nub_post = $this->get_settings_for_display( 'sptour_nub_post' );
		
		?>
		
		<!-- START TOP DEALS -->
		<section id="top_deals" class="top_deals ">
			<div class="container">
				<div class="row">
					<div class="col-md-12" data-aos="fade-up">
						<div class="section-title text-center">
							<span><?php echo turista_wp_kses($sptour_title);?></span>
							<h2><?php echo turista_wp_kses($sptour_content);?></h2>							
						</div>
					</div><!-- END COL -->
				</div><!-- END ROW -->		
				
				<div class="row" data-aos="fade-up">
				<?php
					// WP_Query arguments
					$args = array(
						'post_type'              => array( 'special_tour' ),
						'posts_per_page'         => $sptour_nub_post,
					);

					// The Query
					$turista_spt_query = new WP_Query( $args );

					// The Loop
					if ( $turista_spt_query->have_posts() ) {
						while ( $turista_spt_query->have_posts() ) {
							$turista_spt_query->the_post();					
							$turista_spt_price = get_post_meta(get_the_ID(), '_turista_spt_price', true);
						?>
						<div class="col-sm-4 col-xs-12">
								<div class="single-deal">
									<figure class="effect-sadie ">
										<?php the_post_thumbnail('turista_image_1200_800');?>
										<figcaption>	
											<div class="pull-left">
												<h4><?php the_title();?></h4>
												<p><?php echo esc_html($turista_spt_price);?></p>
											</div>
											
											<div class="pull-right">
												<a href="<?php the_permalink();?>"><i class="icofont-arrow-right"></i></a>
											</div>	
										</figcaption>			
									</figure>
								</div><!--- END GRID -->
							</div><!--- END COL -->						
						<?php
						}
					} else {
						// no posts found
					}

					// Restore original Post Data
					wp_reset_postdata();
				?>				
	
				</div><!--- END ROW -->				
			</div><!--- END CONTAINER-FLUID -->
		</section>
		<!-- END TOP DEALS -->				
					
<?php
	}

}
