<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaContactInfoWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-contact-info';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Contact Info' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_contact_info',
			[
				'label' => esc_html__( 'Contact Info', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	
		$this->add_control(
			'con_icon',
			[
				'label' => esc_html__( 'Icon', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'icofont-google-map',
			]
		);	
		
		$this->add_control(
			'con_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => '2369 Robinson Lane Jackson<br> OH 45640',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$con_icon = $this->get_settings_for_display( 'con_icon' );
		$con_content = $this->get_settings_for_display( 'con_content' );
		
		?>

		<div class="single-contact-info">
			<i class="<?php echo esc_attr($con_icon);?>"></i>
			<p><?php echo turista_wp_kses($con_content);?></p>
		</div>
							

			
<?php
	}

}
